<?php
session_start();
require_once 'config/database.php';

// Get user info
$user_id = $_SESSION['user_id'];
$sql = "SELECT username, email, role FROM users WHERE id = $user_id";
$result = $con->query($sql);
$user = $result ? $result->fetch_assoc() : null;

// If user not found, create empty user array to prevent sidebar errors
if (!$user) {
    $user = [
        'username' => 'Unknown',
        'email' => '',
        'role' => 'user'
    ];
}

// Layout variables
$page_title = 'Yeni Cihaz';
$breadcrumb_title = 'Yeni Cihaz';
$current_page = 'devices';
$extra_css = '';
$page_scripts = '';
?>

<?php require_once 'layouts/header.php'; ?>

<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <?php require_once 'layouts/navbar.php'; ?>
    <?php require_once 'layouts/sidebar.php'; ?>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <?php require_once 'layouts/header_dashboard.php'; ?>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-plus mr-1"></i>
                                Yeni Cihaz Ekle
                            </h3>
                        </div>
                        <div class="card-body">
                            <form action="save_device.php" method="POST">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="device_name">Cihaz Adı</label>
                                            <input type="text" class="form-control" id="device_name" name="device_name" required>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="device_id">Device ID</label>
                                            <input type="text" class="form-control" id="device_id" name="device_id" required>
                                            <small class="form-text text-muted">ESP32'nin benzersiz kimliği</small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="screen_type">Ekran Tipi</label>
                                            <select class="form-control" id="screen_type" name="screen_type" required>
                                                <option value="">Seçiniz...</option>
                                                <option value="ST7789_170x320">ST7789 170x320</option>
                                                <option value="ST7789_240x240">ST7789 240x240</option>
                                                <option value="ILI9341_320x240">ILI9341 320x240</option>
                                                <option value="OLED_128x64">OLED 128x64</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="description">Açıklama</label>
                                            <textarea class="form-control" id="description" name="description" rows="4"></textarea>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="location">Konum</label>
                                            <input type="text" class="form-control" id="location" name="location">
                                        </div>
                                        
                                        <div class="form-group">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" checked>
                                                <label class="form-check-label" for="is_active">
                                                    Aktif
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-save"></i> Kaydet
                                        </button>
                                        <a href="devices.php" class="btn btn-secondary">
                                            <i class="fas fa-times"></i> İptal
                                        </a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<?php require_once 'layouts/footer.php'; ?>
