<?php
session_start();
require_once 'config/database.php';

// Check if user is logged in and is admin
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

// Get user info
$user_id = $_SESSION['user_id'];
$sql = "SELECT username, email, role FROM users WHERE id = $user_id";
$result = $con->query($sql);
$user = $result ? $result->fetch_assoc() : null;

if (!$user || $user['role'] !== 'admin') {
    header('Location: dashboard.php');
    exit();
}

// Get system statistics
$users_sql = "SELECT COUNT(*) as total_users FROM users";
$users_result = $con->query($users_sql);
$users_stats = $users_result ? $users_result->fetch_assoc() : ['total_users' => 0];

$devices_sql = "SELECT COUNT(*) as total_devices FROM devices";
$devices_result = $con->query($devices_sql);
$devices_stats = $devices_result ? $devices_result->fetch_assoc() : ['total_devices' => 0];

// Layout variables
$page_title = 'Sistem Ayarları';
$breadcrumb_title = 'Sistem Ayarları';
$current_page = 'admin_settings';
$extra_css = '';
$page_scripts = '';
?>

<?php require_once 'layouts/header.php'; ?>

<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <?php require_once 'layouts/navbar.php'; ?>
    <?php require_once 'layouts/sidebar.php'; ?>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <?php require_once 'layouts/header_dashboard.php'; ?>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-cogs mr-1"></i>
                                Sistem Ayarları
                            </h3>
                        </div>
                        <div class="card-body">
                            <!-- System Statistics -->
                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-info"><i class="fas fa-users"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Toplam Kullanıcı</span>
                                            <span class="info-box-number"><?php echo $users_stats['total_users']; ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-success"><i class="fas fa-microchip"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Toplam Cihaz</span>
                                            <span class="info-box-number"><?php echo $devices_stats['total_devices']; ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-warning"><i class="fas fa-database"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Veritabanı</span>
                                            <span class="info-box-number">MySQL</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-danger"><i class="fas fa-server"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Server</span>
                                            <span class="info-box-number">XAMPP</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Settings Tabs -->
                            <div class="row">
                                <div class="col-12">
                                    <ul class="nav nav-tabs" id="settingsTabs" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" id="general-tab" data-toggle="tab" href="#general" role="tab">
                                                <i class="fas fa-cog mr-1"></i> Genel
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" id="database-tab" data-toggle="tab" href="#database" role="tab">
                                                <i class="fas fa-database mr-1"></i> Veritabanı
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" id="api-tab" data-toggle="tab" href="#api" role="tab">
                                                <i class="fas fa-plug mr-1"></i> API
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" id="backup-tab" data-toggle="tab" href="#backup" role="tab">
                                                <i class="fas fa-save mr-1"></i> Yedekleme
                                            </a>
                                        </li>
                                    </ul>

                                    <div class="tab-content" id="settingsTabContent">
                                        <!-- General Settings -->
                                        <div class="tab-pane fade show active" id="general" role="tabpanel">
                                            <h4>Genel Ayarlar</h4>
                                            <form action="update_settings.php" method="POST">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="site_name">Site Adı</label>
                                                            <input type="text" class="form-control" id="site_name" name="site_name" value="DMAppsESP">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="admin_email">Admin E-posta</label>
                                                            <input type="email" class="form-control" id="admin_email" name="admin_email" value="admin@dmapesp.com">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="timezone">Zaman Dilimi</label>
                                                            <select class="form-control" id="timezone" name="timezone">
                                                                <option value="Europe/Istanbul">Europe/Istanbul</option>
                                                                <option value="UTC">UTC</option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="language">Dil</label>
                                                            <select class="form-control" id="language" name="language">
                                                                <option value="tr">Türkçe</option>
                                                                <option value="en">English</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fas fa-save"></i> Kaydet
                                                </button>
                                            </form>
                                        </div>

                                        <!-- Database Settings -->
                                        <div class="tab-pane fade" id="database" role="tabpanel">
                                            <h4>Veritabanı Ayarları</h4>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <h5>Veritabanı Bilgileri</h5>
                                                    <table class="table table-bordered">
                                                        <tr>
                                                            <th>Host</th>
                                                            <td>localhost</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Database</th>
                                                            <td>dmapesp</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Karakter Set</th>
                                                            <td>utf8mb4</td>
                                                        </tr>
                                                        <tr>
                                                            <th>Collation</th>
                                                            <td>utf8mb4_unicode_ci</td>
                                                        </tr>
                                                    </table>
                                                </div>
                                                <div class="col-md-6">
                                                    <h5>Tablo İstatistikleri</h5>
                                                    <table class="table table-bordered">
                                                        <tr>
                                                            <th>users</th>
                                                            <td><?php echo $users_stats['total_users']; ?> kayıt</td>
                                                        </tr>
                                                        <tr>
                                                            <th>devices</th>
                                                            <td><?php echo $devices_stats['total_devices']; ?> kayıt</td>
                                                        </tr>
                                                        <tr>
                                                            <th>sensor_data</th>
                                                            <td>-</td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- API Settings -->
                                        <div class="tab-pane fade" id="api" role="tabpanel">
                                            <h4>API Ayarları</h4>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="api_base_url">API Base URL</label>
                                                        <input type="text" class="form-control" id="api_base_url" name="api_base_url" value="https://www.tehlikesiz.com/esp/api/">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="api_timeout">API Timeout (saniye)</label>
                                                        <input type="number" class="form-control" id="api_timeout" name="api_timeout" value="30">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="jwt_secret">JWT Secret</label>
                                                        <input type="text" class="form-control" id="jwt_secret" name="jwt_secret" value="your_jwt_secret_key">
                                                        <small class="form-text text-muted">Güvenlik için değiştirin</small>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="jwt_expiry">JWT Expiry (saat)</label>
                                                        <input type="number" class="form-control" id="jwt_expiry" name="jwt_expiry" value="24">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Backup Settings -->
                                        <div class="tab-pane fade" id="backup" role="tabpanel">
                                            <h4>Yedekleme</h4>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <h5>Otomatik Yedekleme</h5>
                                                    <div class="form-group">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" id="auto_backup" name="auto_backup">
                                                            <label class="form-check-label" for="auto_backup">
                                                                Otomatik yedekleme aktif
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="backup_frequency">Yedekleme Sıklığı</label>
                                                        <select class="form-control" id="backup_frequency" name="backup_frequency">
                                                            <option value="daily">Günlük</option>
                                                            <option value="weekly">Haftalık</option>
                                                            <option value="monthly">Aylık</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <h5>Manuel Yedekleme</h5>
                                                    <button class="btn btn-success mb-3" onclick="createBackup()">
                                                        <i class="fas fa-download"></i> Veritabanı Yedekle
                                                    </button>
                                                    <button class="btn btn-warning mb-3" onclick="restoreBackup()">
                                                        <i class="fas fa-upload"></i> Yedek Geri Yükle
                                                    </button>
                                                    <button class="btn btn-info mb-3" onclick="exportData()">
                                                        <i class="fas fa-file-export"></i> Veri Export
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<script>
function createBackup() {
    alert('Yedekleme özelliği yakinda eklenecek!');
}

function restoreBackup() {
    alert('Yedek geri yükleme özelliği yakında eklenecek!');
}

function exportData() {
    alert('Veri export özelliği yakında eklenecek!');
}
</script>

<?php require_once 'layouts/footer.php'; ?>
