<?php
$user_id = authenticate();

switch ($method) {
    case 'GET':
        // Get available firmware versions
        $device_type = $_GET['device_type'] ?? null;
        
        $where_conditions = ["is_active = 1"];
        $params = [];
        $types = "";
        
        if ($device_type) {
            $where_conditions[] = "device_type = ?";
            $params[] = $device_type;
            $types .= "s";
        }
        
        $sql = "
            SELECT * FROM firmware_versions 
            WHERE " . implode(" AND ", $where_conditions) . "
            ORDER BY created_at DESC
        ";
        
        if (!empty($params)) {
            $stmt = $GLOBALS['con']->prepare($sql);
            $stmt->bind_param($types, ...$params);
            $stmt->execute();
            $result = $stmt->get_result();
        } else {
            $result = $GLOBALS['con']->query($sql);
        }
        
        $firmware_versions = [];
        while ($row = $result->fetch_assoc()) {
            $firmware_versions[] = $row;
        }
        
        echo json_encode($firmware_versions);
        break;
        
    case 'POST':
        // Add new firmware version (admin only)
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (!isset($data['device_type']) || !isset($data['version']) || !isset($data['file_path'])) {
            http_response_code(400);
            echo json_encode(['error' => 'device_type, version, and file_path are required']);
            break;
        }
        
        // Check if user is admin (you might want to add an admin role to users table)
        $stmt = $GLOBALS['con']->prepare("SELECT email FROM users WHERE id = ? AND email IN ('unalduzgun@gmail.com', 'atikyonet@gmail.com')");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            http_response_code(403);
            echo json_encode(['error' => 'Admin access required']);
            break;
        }
        
        $device_type = $data['device_type'];
        $version = $data['version'];
        $file_path = $data['file_path'];
        $manifest_path = $data['manifest_path'] ?? null;
        $release_notes = $data['release_notes'] ?? null;
        
        // Check if firmware version already exists
        $stmt = $GLOBALS['con']->prepare("SELECT id FROM firmware_versions WHERE device_type = ? AND version = ?");
        $stmt->bind_param("ss", $device_type, $version);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            http_response_code(409);
            echo json_encode(['error' => 'Firmware version already exists']);
            break;
        }
        
        // Insert firmware version
        $stmt = $GLOBALS['con']->prepare("
            INSERT INTO firmware_versions (device_type, version, file_path, manifest_path, release_notes) 
            VALUES (?, ?, ?, ?, ?)
        ");
        $stmt->bind_param("sssss", $device_type, $version, $file_path, $manifest_path, $release_notes);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'firmware_id' => $stmt->insert_id]);
        } else {
            http_response_code(500);
            echo json_encode(['error' => 'Failed to add firmware version']);
        }
        break;
        
    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?>
