<?php
session_start();

// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'dmapesp');
define('DB_PASS', 'DmAppsESP@2024!');
define('DB_NAME', 'dmapesp');

// API Configuration
define('API_VERSION', 'v1');
define('JWT_SECRET', 'your_jwt_secret_key');
define('JWT_EXPIRY', 86400); // 24 hours

// Security
define('ENCRYPTION_KEY', 'your_encryption_key');
define('HASH_ALGO', 'sha256');

// Create database connection
$con = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if ($con->connect_error) {
    die("Connection failed: " . $con->connect_error);
}

// Set charset
$con->set_charset("utf8mb4");

// Include functions
require_once 'functions.php';
require_once 'jwt.php';
?>

<!DOCTYPE html>
<html>
<head>
    <title>DMAppsESP Database Status</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .status { padding: 20px; border-radius: 8px; }
        .success { background: #d4edda; color: #155724; }
        .error { background: #f8d7da; color: #721c24; }
        .info { background: #d1ecf1; color: #856404; }
        h2 { margin-top: 0; }
        .test-btn { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        .test-btn:hover { background: #0056b3; }
    </style>
</head>
<body>
    <div class='status success'>
        <h2>✅ Database Bağlantısı Başarılı!</h2>
        <p><strong>Database Host:</strong> <?php echo DB_HOST; ?></p>
        <p><strong>Database User:</strong> <?php echo DB_USER; ?></p>
        <p><strong>Database Name:</strong> <?php echo DB_NAME; ?></p>
        <p><strong>Database Password:</strong> DmAppsESP@2024!</p>
    </div>
    
    <div class='info'>
        <h3>📊 Veritabanı Bilgileri</h3>
        <p><strong>MySQL Version:</strong> <?php echo $con->server_info; ?></p>
        <p><strong>Karakter Set:</strong> <?php echo $con->character_set_name; ?></p>
    </div>
    
    <div class='info'>
        <h3>📋 Tablolar</h3>
        <ul>
        <?php
        // Tabloları listele
        $tables_result = $con->query("SHOW TABLES");
        while ($table = $tables_result->fetch_row()) {
            echo "<li><strong>" . $table[0] . "</strong> - Veri tablosu</li>";
        }
        ?>
        </ul>
    </div>
    
    <div class='info'>
        <h3>🔧 Test İşlemleri</h3>
        <button class='test-btn' onclick='testQuery()'>Test Query</button>
        <button class='test-btn' onclick='testInsert()'>Test Insert</button>
        <button class='test-btn' onclick='testUpdate()'>Test Update</button>
        <button class='test-btn' onclick='testDelete()'>Test Delete</button>
    </div>
    
    <div id='test-results'></div>
    
    <script>
        function testQuery() {
            fetch('test_db.php?action=query')
                .then(response => response.text())
                .then(data => {
                    document.getElementById('test-results').innerHTML = '<h4>Query Test:</h4><pre>' + data + '</pre>';
                });
        }
        
        function testInsert() {
            fetch('test_db.php?action=insert')
                .then(response => response.text())
                .then(data => {
                    document.getElementById('test-results').innerHTML = '<h4>Insert Test:</h4><pre>' + data + '</pre>';
                });
        }
        
        function testUpdate() {
            fetch('test_db.php?action=update')
                .then(response => response.text())
                .then(data => {
                    document.getElementById('test-results').innerHTML = '<h4>Update Test:</h4><pre>' + data + '</pre>';
                });
        }
        
        function testDelete() {
            fetch('test_db.php?action=delete')
                .then(response => response.text())
                .then(data => {
                    document.getElementById('test-results').innerHTML = '<h4>Delete Test:</h4><pre>' + data + '</pre>';
                });
        }
    </script>
</body>
</html>
