<?php
require_once '../config/database.php';

header('Content-Type: application/json');

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'query':
        // Test query
        $result = $con->query("SELECT COUNT(*) as count FROM users");
        $row = $result->fetch_assoc();
        echo json_encode(['success' => true, 'message' => 'Users tablosunda ' . $row['count'] . ' kayıt var']);
        break;
        
    case 'insert':
        // Test insert
        $stmt = $con->prepare("INSERT INTO system_logs (log_level, category, message) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", 'INFO', 'test', 'Test log message');
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Test log kaydı eklendi']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Hata: ' . $con->error]);
        }
        break;
        
    case 'update':
        // Test update
        $stmt = $con->prepare("UPDATE system_logs SET message = ? WHERE category = ?");
        $stmt->bind_param("ss", 'Updated test message', 'test');
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Test log kaydı güncellendi']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Hata: ' . $con->error]);
        }
        break;
        
    case 'delete':
        // Test delete
        $stmt = $con->prepare("DELETE FROM system_logs WHERE category = ?");
        $stmt->bind_param("s", 'test');
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Test log kayıtları silindi']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Hata: ' . $con->error]);
        }
        break;
        
    default:
        echo json_encode(['success' => false, 'message' => 'Geçersiz işlem']);
        break;
}
?>
