<?php
session_start();
require_once 'config/database.php';

// Get user info
$user_id = $_SESSION['user_id'];
$sql = "SELECT username, email, role FROM users WHERE id = $user_id";
$result = $con->query($sql);
$user = $result ? $result->fetch_assoc() : null;

// If user not found, create empty user array to prevent sidebar errors
if (!$user) {
    $user = [
        'username' => 'Unknown',
        'email' => '',
        'role' => 'user'
    ];
}

// Get user devices (admin can also have their own devices)
$devices_sql = "SELECT * FROM devices WHERE owner_id = $user_id ORDER BY created_at DESC";
$devices_result = $con->query($devices_sql);
$devices = $devices_result ? $devices_result->fetch_all(MYSQLI_ASSOC) : [];

// Layout variables
$page_title = 'Cihazlar';
$breadcrumb_title = 'Cihazlar';
$current_page = 'devices';
$extra_css = '<link rel="stylesheet" href="assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">';
$page_scripts = '<script src="assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>';
?>

<?php require_once 'layouts/header.php'; ?>

<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <?php require_once 'layouts/navbar.php'; ?>
    <?php require_once 'layouts/sidebar.php'; ?>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <?php require_once 'layouts/header_dashboard.php'; ?>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-microchip mr-1"></i>
                                Cihazlarım
                            </h3>
                            <div class="card-tools">
                                <a href="add_device.php" class="btn btn-primary btn-sm">
                                    <i class="fas fa-plus"></i> Yeni Cihaz
                                </a>
                            </div>
                        </div>
                        
                        <div class="card-body">
                            <table id="devicesTable" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Cihaz Adı</th>
                                        <th>Device ID</th>
                                        <th>Durum</th>
                                        <th>Ekran Tipi</th>
                                        <th>Son Aktivite</th>
                                        <th>İşlemler</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($devices as $device): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($device['device_name']); ?></td>
                                        <td><code><?php echo htmlspecialchars($device['device_id']); ?></code></td>
                                        <td>
                                            <?php if ($device['status'] === 'online'): ?>
                                                <span class="badge badge-success">Online</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Offline</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo htmlspecialchars($device['screen_type'] ?? 'Bilinmiyor'); ?></td>
                                        <td><?php echo $device['last_activity'] ? date('d.m.Y H:i', strtotime($device['last_activity'])) : '-'; ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="device_detail.php?id=<?php echo $device['id']; ?>" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="edit_device.php?id=<?php echo $device['id']; ?>" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-cog"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#devicesTable').DataTable({
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "ordering": true,
        "info": true,
        "paging": true,
        "search": true,
        "language": {
            "search": "Ara:",
            "lengthMenu": "Show _MENU_ entries",
            "info": "Showing _START_ to _END_ of _TOTAL_ entries",
            "paginate": {
                "first": "İlk",
                "last": "Son",
                "next": "Sonraki",
                "previous": "Önceki"
            }
        }
    });
});
</script>

<?php require_once 'layouts/footer.php'; ?>
