<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Web Flasher - DMAppsESP</title>
    
    <!-- POS AdminLTE CSS -->
    <link rel="stylesheet" href="assets/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
    
    <style>
        .flasher-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .device-card {
            border: 2px solid #007bff;
            border-radius: 10px;
            transition: all 0.3s;
        }
        .device-card:hover {
            border-color: #0056b3;
            box-shadow: 0 8px 25px rgba(0,123,255,0.3);
        }
        .step-indicator {
            background: #007bff;
            color: white;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
    </style>
</head>
<body class="hold-transition layout-top-nav">

<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand-md navbar-light navbar-white">
        <div class="container">
            <a href="index.php" class="navbar-brand">
                <i class="fas fa-microchip"></i> DMAppsESP
            </a>
            
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a href="index.php" class="nav-link">
                        <i class="fas fa-home"></i> Ana Sayfa
                    </a>
                </li>
                <li class="nav-item">
                    <a href="login.php" class="nav-link">
                        <i class="fas fa-user-shield"></i> Admin Panel
                    </a>
                </li>
            </ul>
        </div>
    </nav>

    <!-- Content -->
    <div class="content-wrapper">
        <div class="container py-5">
            <div class="flasher-container">
                <!-- Header -->
                <div class="text-center mb-5">
                    <h1 class="display-4">
                        <i class="fas fa-download text-success"></i> Web Flasher
                    </h1>
                    <p class="lead text-muted">
                        ESP32 cihazınıza firmware yüklemek için aşağıdaki adımları izleyin
                    </p>
                </div>

                <!-- Device Selection -->
                <div class="card device-card mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-microchip"></i> Cihaz Seçimi
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="deviceSelect">Cihaz Tipi:</label>
                            <select class="form-control" id="deviceSelect" onchange="updateManifest()">
                                <option value="ST7789_170x320">ESP32 + ST7789 170x320 (IdeaSpark)</option>
                                <option value="ST7789_240x240">ESP32 + ST7789 240x240 (1.54")</option>
                                <option value="ILI9341_320x240">ESP32 + ILI9341 320x240</option>
                                <option value="OLED_128x64">ESP32 + OLED 128x64</option>
                            </select>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            <strong>Not:</strong> Cihazınızın ekran tipine uygun olanı seçin.
                        </div>
                    </div>
                </div>

                <!-- Instructions -->
                <div class="card mb-4">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-list-ol"></i> Kurulum Adımları
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="d-flex align-items-start mb-3">
                                    <span class="step-indicator me-3">1</span>
                                    <div>
                                        <strong>USB Bağlantısı</strong>
                                        <p class="text-muted mb-0">ESP32'yi USB kablo ile bilgisayara bağlayın</p>
                                    </div>
                                </div>
                                
                                <div class="d-flex align-items-start mb-3">
                                    <span class="step-indicator me-3">2</span>
                                    <div>
                                        <strong>Cihaz Seçimi</strong>
                                        <p class="text-muted mb-0">Yukarıdan doğru cihaz tipini seçin</p>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="d-flex align-items-start mb-3">
                                    <span class="step-indicator me-3">3</span>
                                    <div>
                                        <strong>Port Seçimi</strong>
                                        <p class="text-muted mb-0">"Connect" butonuna basıp COM port seçin</p>
                                    </div>
                                </div>
                                
                                <div class="d-flex align-items-start mb-3">
                                    <span class="step-indicator me-3">4</span>
                                    <div>
                                        <strong>Flash İşlemi</strong>
                                        <p class="text-muted mb-0">İşlemin tamamlanmasını bekleyin</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Flasher -->
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">
                            <i class="fas fa-rocket"></i> Firmware Flasher
                        </h5>
                    </div>
                    <div class="card-body text-center">
                        <div id="flasherContainer">
                            <p class="mb-4">
                                <i class="fas fa-download fa-3x text-success"></i>
                            </p>
                            
                            <esp-web-install-button 
                                id="flashButton" 
                                manifest="flasher/manifest_ST7789_170x320.json">
                            </esp-web-install-button>
                            
                            <div class="mt-4">
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    <strong>Önemli:</strong> Flash işlemi sırasında cihazı USB'den çıkarmayın!
                                </div>
                            </div>
                        </div>
                        
                        <div id="successMessage" style="display: none;" class="alert alert-success">
                            <i class="fas fa-check-circle fa-2x"></i>
                            <h4>Firmware Başarıyla Yüklendi!</h4>
                            <p>Cihazınız yeniden başlatılıyor. Lütfen bekleyin...</p>
                            <button class="btn btn-primary" onclick="location.reload()">
                                <i class="fas fa-redo"></i> Yeni Cihaz Flash Et
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Troubleshooting -->
                <div class="card mt-4">
                    <div class="card-header bg-warning text-dark">
                        <h5 class="mb-0">
                            <i class="fas fa-tools"></i> Sorun Giderme
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6><i class="fas fa-question-circle text-info"></i> Port Görünmüyor mu?</h6>
                                <ul>
                                    <li>USB kabloyu kontrol edin</li>
                                    <li>ESP32'yi yeniden bağlayın</li>
                                    <li>Driver'ları yükleyin (CP210x/CH340)</li>
                                </ul>
                            </div>
                            
                            <div class="col-md-6">
                                <h6><i class="fas fa-question-circle text-info"></i> Flash Başarısız mı?</h6>
                                <ul>
                                    <li>Cihazı flash modda başlatın (BOOT butonu)</li>
                                    <li>Farklı USB portu deneyin</li>
                                    <li>Tarayıcıyı yenileyin</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- POS AdminLTE JS -->
<script src="assets/plugins/jquery/jquery.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/dist/js/adminlte.min.js"></script>

<!-- Web Flasher Script -->
<script type="module" src="https://unpkg.com/esp-web-tools@9.2.1/dist/web/install-button.js"></script>

<script>
function updateManifest() {
    const deviceType = document.getElementById('deviceSelect').value;
    const flashButton = document.getElementById('flashButton');
    
    // Manifest dosyasını güncelle
    flashButton.setAttribute('manifest', `flasher/manifest_${deviceType}.json`);
    
    console.log('Manifest updated to:', `flasher/manifest_${deviceType}.json`);
}

// Flash başarılı olduğunda
document.addEventListener('esp-web-tools-flash-complete', function() {
    document.getElementById('flasherContainer').style.display = 'none';
    document.getElementById('successMessage').style.display = 'block';
});

// Sayfa yüklendiğinde
document.addEventListener('DOMContentLoaded', function() {
    updateManifest();
});
</script>

</body>
</html>
