# DMAppsESP Web Flasher

## 📋 Kurulum ve Kullanım

### **1. Web Sunucusu Başlatma**
```bash
# web-panel dizinine gidin
cd DMAppsESP/web-panel

# PHP内置 sunucuyu başlatın
php -S localhost:8000

# Veya Apache/Nginx kullanın
# http://localhost/DMAppsESP/web-panel/
```

### **2. Flasher Kullanımı**
1. **Tarayıcıda açın:** `http://localhost:8000/flasher.php`
2. **Cihaz seçin:** ESP32 + ST7789 170x320 (IdeaSpark)
3. **ESP32'yi bağlayın:** USB kablo ile bilgisayara
4. **Flash edin:** "Connect" → Port seç → Flash

### **3. Desteklenen Cihazlar**
- ✅ **ESP32 + ST7789 170x320** (IdeaSpark)
- ✅ **ESP32 + ILI9341 320x240** (Generic)
- ✅ **ESP32 + OLED 128x64** (Generic)

---

## 🔧 Teknik Detaylar

### **Manifest Dosyaları**
- `manifest_ST7789_170x320.json` - IdeaSpark board
- `manifest_ILI9341_320x240.json` - ILI9341 display
- `manifest_OLED_128x64.json` - OLED display

### **Firmware Dosya Yapısı**
```
firmware/build/
├── ST7789_170x320/
│   ├── firmware.bin     (Ana firmware)
│   ├── bootloader.bin   (Bootloader)
│   └── partitions.bin  (Partition table)
├── ILI9341_320x240/
└── OLED_128x64/
```

### **Web Serial API**
- **esp-web-tools@9.2.1** kullanılır
- **Chrome/Edge** tarayıcıları desteklenir
- **HTTPS** gerekmez (localhost için)

---

## 🚨 Önemli Notlar

### **Flash Öncesi:**
- 🔌 **USB driver'ları** yükleyin (CP210x/CH340)
- 🔌 **Doğru COM port** seçin
- 🔌 **ESP32'yi flash modda** başlatın (gerekirse)

### **Flash Sırasında:**
- ⚠️ **USB'yi çıkarmayın**
- ⚠️ **İşlemi iptal etmeyin**
- ⚠️ **Bilgisayarı kapatmayın**

### **Flash Sonrası:**
- ✅ **ESP32'yi yeniden başlatın**
- ✅ **QR kodu kontrol edin**
- ✅ **Android uygulamasını** hazırlayın

---

## 🐛 Sorun Giderme

### **Port Görünmüyor mu?**
1. USB kabloyu kontrol edin
2. ESP32'yi yeniden bağlayın
3. Driver'ları yükleyin
4. Farklı USB portu deneyin

### **Flash Başarısız mı?**
1. ESP32'yi flash modda başlatın (BOOT butonu basılı tutun)
2. Farklı USB portu deneyin
3. Tarayıcıyı yenileyin
4. Cache'i temizleyin

### **Manifest Hatası mı?**
1. Firmware dosyalarının var olduğunu kontrol edin
2. Dosya yollarını doğrulayın
3. JSON formatını kontrol edin

---

## 📱 Sonraki Adımlar

1. **Firmware yüklendikten sonra** ESP32 QR kod gösterir
2. **Android uygulaması** ile QR kodu okutun
3. **BLE üzerinden** Wi-Fi bilgilerini gönderin
4. **Web panel** üzerinden cihazı yönetin

---

## 🔗 Bağlantılar

- **Ana Sayfa:** `http://localhost:8000/index.php`
- **Flasher:** `http://localhost:8000/flasher.php`
- **Admin Panel:** `http://localhost:8000/login.php`

---

**DMAppsESP Web Flasher - Firmware Yüklemenin Kolay Yolu** 🚀
