<?php
require_once 'config/database.php';

// Check if user is logged in, redirect to dashboard
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit();
}

// Layout variables
$page_title = 'DMAppsESP - IoT Device Manager';
$breadcrumb_title = 'Ana Sayfa';
$current_page = 'home';
$extra_css = '<style>
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 100px 0;
            text-align: center;
        }
        .feature-card {
            transition: transform 0.3s;
            border: none;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .feature-card:hover {
            transform: translateY(-5px);
        }
        .btn-flash {
            background: #28a745;
            color: white;
            padding: 15px 30px;
            font-size: 18px;
            border-radius: 50px;
            text-decoration: none;
            display: inline-block;
            margin: 20px 10px;
            transition: all 0.3s;
        }
        .btn-flash:hover {
            background: #218838;
            transform: scale(1.05);
            color: white;
        }
        .btn-admin {
            background: #007bff;
            color: white;
            padding: 15px 30px;
            font-size: 18px;
            border-radius: 50px;
            text-decoration: none;
            display: inline-block;
            margin: 20px 10px;
            transition: all 0.3s;
        }
        .btn-admin:hover {
            background: #0056b3;
            transform: scale(1.05);
            color: white;
        }
    </style>';
?>

<?php require_once 'layouts/header.php'; ?>

<body class="hold-transition layout-top-nav">
<div class="wrapper">
    <?php require_once 'layouts/navbar.php'; ?>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <!-- Hero Section -->
        <section class="hero-section">
            <div class="container">
                <h1 class="display-4 mb-4">
                    <i class="fas fa-microchip"></i> DMAppsESP
                </h1>
                <p class="lead mb-5">
                    ESP32 cihazlarinizi kolayca yonetin, firmware yukleyin ve kontrol edin
                </p>
                
                <div class="row justify-content-center">
                    <div class="col-md-8">
                        <div class="card bg-white text-dark">
                            <div class="card-body">
                                <h5 class="card-title">
                                    <i class="fas fa-rocket"></i> Hizli Baslangic
                                </h5>
                                <p class="card-text">
                                    ESP32 cihazinizi firmware ile yuklemek icin Web Flasher'i kullanin
                                </p>
                                
                                <a href="flasher.php" class="btn-flash">
                                    <i class="fas fa-download"></i> Web Flasher
                                </a>
                                
                                <a href="login.php" class="btn-admin">
                                    <i class="fas fa-user-shield"></i> Admin Panel
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Features Section -->
        <section class="py-5">
            <div class="container">
                <div class="row text-center mb-5">
                    <div class="col">
                        <h2>Ozellikler</h2>
                        <p class="text-muted">IoT cihaz yonetim sistemi</p>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4 mb-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <i class="fas fa-download fa-3x text-success mb-3"></i>
                                <h5 class="card-title">Web Flasher</h5>
                                <p class="card-text">
                                    Tarayici uzerinden ESP32 firmware yukleyin. 
                                    Kurulum gerektirmez, aninda kullanin.
                                </p>
                                <a href="flasher.php" class="btn btn-success">
                                    <i class="fas fa-arrow-right"></i> Flash Et
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <i class="fas fa-mobile-alt fa-3x text-primary mb-3"></i>
                                <h5 class="card-title">Android Uygulama</h5>
                                <p class="card-text">
                                    QR kod okutarak ESP32'yi Bluetooth uzerinden yapilandirin
                                    ve Wi-Fi ayarlarini guvenli sekilde gonderin.
                                </p>
                                <a href="#" class="btn btn-primary" onclick="showComingSoon()">
                                    <i class="fas fa-download"></i> Indir
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card feature-card h-100">
                            <div class="card-body text-center">
                                <i class="fas fa-chart-line fa-3x text-info mb-3"></i>
                                <h5 class="card-title">Cihaz Yonetimi</h5>
                                <p class="card-text">
                                    Sensor verilerini gercek zamanli izleyin, 
                                    cihazlari uzaktan kontrol edin.
                                </p>
                                <a href="login.php" class="btn btn-info">
                                    <i class="fas fa-tachometer-alt"></i> Panel
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<script>
function showComingSoon() {
    alert('Android uygulama yakinda yayinlanacak!');
}
</script>

<?php require_once 'layouts/footer.php'; ?>
