<?php
require_once 'config/database.php';

// Handle login
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (empty($email) || empty($password)) {
        $error = 'E-posta ve şifre alanları zorunludur.';
    } else {
        $email = $con->real_escape_string($email);
        // Check if user exists
        $sql = "SELECT * FROM users WHERE email = '$email'";
        $result = $con->query($sql);
        
        if ($result && $result->num_rows > 0) {
            $user = $result->fetch_assoc();
            
            if (password_verify($password, $user['password_hash'])) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['user']['role'] = $user['role'];
                $_SESSION['user']['username'] = $user['username'];
                $_SESSION['user']['email'] = $user['email'];
                
                header('Location: dashboard.php');
                exit();
            } else {
                $error = 'E-posta veya şifre hatalı.';
            }
        } else {
            $error = 'Kullanıcı bulunamadı.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DMAppsESP - Giriş</title>
    
    <!-- POS AdminLTE CSS -->
    <link rel="stylesheet" href="assets/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
    <style>
        .login-page {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .login-box {
            width: 360px;
            margin: 7% auto;
        }
        .login-logo {
            font-size: 2.5rem;
            font-weight: 300;
            margin-bottom: 25px;
        }
        .login-box-body {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }
        .btn-primary {
            background: #667eea;
            border-color: #667eea;
        }
        .btn-primary:hover {
            background: #5a67d8;
            border-color: #5a67d8;
        }
    </style>
</head>
<body class="hold-transition login-page">
<div class="login-box">
    <div class="login-logo text-center">
        <i class="fas fa-microchip"></i>
        <b>DMAppsESP</b>
    </div>
    
    <div class="card">
        <div class="card-body login-box-body p-4">
            <p class="login-box-msg">IoT Cihaz Yönetim Paneli</p>
            
            <?php if (isset($error)): ?>
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <?php echo htmlspecialchars($error); ?>
            </div>
            <?php endif; ?>
            
            <form action="login.php" method="post">
                <div class="input-group mb-3">
                    <input type="email" name="email" class="form-control" placeholder="E-posta" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                </div>
                
                <div class="input-group mb-3">
                    <input type="password" name="password" class="form-control" placeholder="Şifre" required>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-lock"></span>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary btn-block">Giriş Yap</button>
                    </div>
                </div>
            </form>
            
            <p class="mb-1">
                <a href="flasher.php" class="text-center">
                    <i class="fas fa-download"></i> Firmware Flasher
                </a>
            </p>
            
            <p class="mb-0">
                <a href="register.php" class="text-center">
                    Yeni Hesap Oluştur
                </a>
            </p>
        </div>
    </div>
</div>

<!-- POS AdminLTE JS -->
<script src="assets/plugins/jquery/jquery.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/dist/js/adminlte.min.js"></script>

<script>
// Auto-focus on email field
$(document).ready(function() {
    $('input[name="email"]').focus();
});
</script>

</body>
</html>
