<?php
session_start();
require_once 'config/database.php';

// Get user info
$user_id = $_SESSION['user_id'];
$sql = "SELECT username, email, role FROM users WHERE id = $user_id";
$result = $con->query($sql);
$user = $result ? $result->fetch_assoc() : null;

// If user not found, create empty user array to prevent sidebar errors
if (!$user) {
    $user = [
        'username' => 'Unknown',
        'email' => '',
        'role' => 'user'
    ];
}

// Layout variables
$page_title = 'DMAppsESP - Mobile Responsive';
$breadcrumb_title = 'Mobile Responsive';
$current_page = 'mobile';
$extra_css = '<style>
    .mobile-container {
        max-width: 100%;
        padding: 10px;
        margin: 0 auto;
    }
    .mobile-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 15px;
        border-radius: 10px;
        margin-bottom: 15px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    .mobile-nav {
        background: white;
        border-radius: 10px;
        padding: 10px;
        margin-bottom: 15px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    .mobile-nav .nav-item {
        display: flex;
        align-items: center;
        padding: 10px;
        border-radius: 8px;
        margin-bottom: 5px;
        cursor: pointer;
        transition: background-color 0.3s;
    }
    .mobile-nav .nav-item:hover {
        background-color: #f8f9fa;
    }
    .mobile-nav .nav-item.active {
        background-color: #007bff;
        color: white;
    }
    .mobile-nav .nav-icon {
        font-size: 20px;
        margin-right: 10px;
        width: 24px;
        text-align: center;
    }
    .mobile-card {
        background: white;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
        box-shadow: 0 2px 10px rgba(00,0,0.1);
    }
    .mobile-card h5 {
        margin-bottom: 10px;
        color: #333;
    }
    .mobile-stats {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
        margin-bottom: 15px;
    }
    .mobile-stat {
        background: #f8f9fa;
        border-radius: 8px;
        padding: 15px;
        text-align: center;
    }
    .mobile-stat .value {
        font-size: 24px;
        font-weight: bold;
        color: #007bff;
    }
    .mobile-stat .label {
        font-size: 12px;
        color: #6c757d;
        margin-top: 5px;
    }
    .mobile-sensor-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
    }
    .mobile-sensor {
        background: #f8f9fa;
        border-radius: 8px;
        padding: 15px;
        text-align: center;
        border-left: 4px solid #007bff;
    }
    .mobile-sensor .value {
        font-size: 18px;
        font-weight: bold;
        color: #007bff;
    }
    .mobile-sensor .unit {
        font-size: 12px;
        color: #6c757d;
    }
    .mobile-button {
        background: #007bff;
        color: white;
        border: none;
        border-radius: 8px;
        padding: 12px 20px;
        font-size: 14px;
        cursor: pointer;
        width: 100%;
        margin-bottom: 10px;
        transition: background-color 0.3s;
    }
    .mobile-button:hover {
        background: #0056b3;
    }
    .mobile-button.secondary {
        background: #6c757d;
    }
    .mobile-button.secondary:hover {
        background: #5a6268;
    }
    .mobile-button.danger {
        background: #dc3545;
    }
    .mobile-button.danger:hover {
        background: #c82333;
    }
    .mobile-button.success {
        background: #28a745;
    }
    .mobile-button.success:hover {
        background: #218838;
    }
    .mobile-device-list {
        margin-bottom: 15px;
    }
    .mobile-device {
        background: white;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 10px;
        border-left: 4px solid #007bff;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    .mobile-device .name {
        font-weight: bold;
        margin-bottom: 5px;
    }
    .mobile-device .info {
        font-size: 12px;
        color: #6c757d;
    }
    .mobile-device .status {
        display: inline-block;
        padding: 2px 8px;
        border-radius: 4px;
        font-size: 10px;
        font-weight: bold;
        margin-top: 5px;
    }
    .status-online { background-color: #d4edda; color: #155724; }
    .status-offline { background-color: #f8d7da; color: #721c24; }
    .status-warning { background-color: #fff3cd; color: #856404; }
    .mobile-alert {
        background: #f8d7da;
        border: 1px solid #f5c6cb;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 10px;
    }
    .mobile-alert.warning {
        background: #fff3cd;
        border-color: #ffeaa7;
    }
    .mobile-alert.info {
        background: #d1ecf1;
        border-color: #bee5eb;
    }
    .mobile-alert .title {
        font-weight: bold;
        margin-bottom: 5px;
    }
    .mobile-alert .message {
        font-size: 14px;
    }
    .mobile-alert .time {
        font-size: 12px;
        color: #6c757d;
        margin-top: 5px;
    }
    .mobile-bottom-nav {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        background: white;
        border-top: 1px solid #dee2e6;
        padding: 10px 0;
        z-index: 1000;
    }
    .mobile-bottom-nav .nav-item {
        flex: 1;
        text-align: center;
        padding: 5px;
        cursor: pointer;
        transition: background-color 0.3s;
    }
    .mobile-bottom-nav .nav-item.active {
        background-color: #f8f9fa;
    }
    .mobile-bottom-nav .nav-icon {
        font-size: 20px;
        margin-bottom: 5px;
    }
    .mobile-bottom-nav .nav-label {
        font-size: 10px;
        color: #6c757d;
    }
    
    /* Responsive design */
    @media (max-width: 768px) {
        .mobile-container {
            padding: 5px;
        }
        .mobile-stats {
            grid-template-columns: repeat(2, 1fr);
            gap: 8px;
        }
        .mobile-sensor-grid {
            grid-template-columns: repeat(2, 1fr);
            gap: 8px;
        }
    }
    
    @media (max-width: 480px) {
        .mobile-stats {
            grid-template-columns: repeat(2, 1fr);
            gap: 5px;
        }
        .mobile-sensor-grid {
            grid-template-columns: repeat(1, 1fr);
            gap: 5px;
        }
    }
    
    /* Touch-friendly */
    .mobile-button, .mobile-nav .nav-item {
        min-height: 44px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    /* Dark mode support */
    @media (prefers-color-scheme: dark) {
        .mobile-card, .mobile-nav, .mobile-device {
            background: #1a1a1a;
            color: #fff;
        }
        .mobile-stat, .mobile-sensor {
            background: #2d2d2d;
            color: #fff;
        }
        .mobile-bottom-nav {
            background: #1a1a1a;
            border-top-color: #495057;
        }
    }
</style>';

$extra_js = '<script>
// Mobil uyumlu fonksiyonlar
function toggleMobileMenu() {
    const nav = document.getElementById(\'mobileNav\');
    nav.style.display = nav.style.display === \'none\' ? \'block\' : \'none\';
}

function showMobileSection(sectionId) {
    // Tüm bölümleri gizle
    const sections = document.querySelectorAll(\'.mobile-section\');
    sections.forEach(section => {
        section.style.display = \'none\';
    });
    
    // Seçili bölümu göster
    const selectedSection = document.getElementById(sectionId);
    if (selectedSection) {
        selectedSection.style.display = \'block\';
    }
    
    // Navigasyon durumunu güncelle
    updateMobileNav(sectionId);
}

function updateMobileNav(activeSection) {
    const navItems = document.querySelectorAll(\'.mobile-nav .nav-item\');
    navItems.forEach(item => {
        item.classList.remove(\'active\');
    });
    
    const activeItem = document.querySelector(\'.mobile-nav .nav-item[data-section="\' + activeSection + \'"]\');
    if (activeItem) {
        activeItem.classList.add(\'active\');
    }
}

function refreshMobileData() {
    // Mobil verileri yenile
    loadMobileDevices();
    loadMobileSensors();
    loadMobileAlerts();
}

function loadMobileDevices() {
    fetch(\'api/devices.php?action=list\')
        .then(response => response.json())
        .then(data => {
            updateMobileDeviceList(data.devices);
        });
}

function updateMobileDeviceList(devices) {
    const container = document.getElementById(\'mobileDeviceList\');
    let html = \'\';
    
    if (devices && devices.length > 0) {
        devices.forEach(device => {
            const statusClass = device.status === \'online\' ? \'status-online\' : 
                                device.status === \'offline\' ? \'status-offline\' : \'status-warning\';
            
            html += \'<div class="mobile-device">\';
            html += \'<div class="name">\' + device.name + \'</div>\';
            html += \'<div class="info">\' + device.device_id + \' | \' + device.esp_model + \'</div>\';
            html += \'<span class="status \' + statusClass + \'">\' + device.status + \'</span>\';
            html += \'</div>\';
        });
    } else {
        html = \'<p class="text-muted">Cihaz bulunamadı.</p>\';
    }
    
    container.innerHTML = html;
}

function loadMobileSensors() {
    // Son sensör verilerini yükle
    fetch(\'api/sensors.php?action=latest\')
        .then(response => response.json())
        .then(data => {
            updateMobileSensors(data.sensors);
        });
}

function updateMobileSensors(sensors) {
    const container = document.getElementById(\'mobileSensorGrid\');
    let html = \'\';
    
    if (sensors && sensors.length > 0) {
        sensors.slice(0, 6).forEach(sensor => {
            html += \'<div class="mobile-sensor">\';
            html += \'<div class="value">\' + sensor.value + \'</div>\';
            html += \'<div class="unit">\' + sensor.unit + \'</div>\';
            html += \'<div class="label">\' + sensor.sensor_code + \'</div>\';
            html += \'</div>\';
        });
    } else {
        html = \'<p class="text-muted">Sensör verisi yok.</p>\';
    }
    
    container.innerHTML = html;
}

function loadMobileAlerts() {
    // Son uyarıları yükle
    fetch(\'api/system.php?action=alerts&limit=5\')
        .then(response => response.json())
        .then(data => {
            updateMobileAlerts(data.alerts);
        });
}

function updateMobileAlerts(alerts) {
    const container = document.getElementById(\'mobileAlerts\');
    let html = \'\';
    
    if (alerts && alerts.length > 0) {
        alerts.forEach(alert => {
            const alertClass = alert.level === \'error\' ? \'mobile-alert\' : 
                                alert.level === \'warning\' ? \'mobile-alert warning\' : \'mobile-alert info\';
            
            html += \'<div class="\' + alertClass + \'">\';
            html += \'<div class="title">\' + alert.title + \'</div>\';
            html += \'<div class="message">\' + alert.message + \'</div>\';
            html += \'<div class="time">\' + alert.timestamp + \'</div>\';
            html += \'</div>\';
        });
    } else {
        html = \'<p class="text-muted">Yeni uyarı yok.</p>\';
    }
    
    container.innerHTML = html;
}

function toggleMobileTheme() {
    document.body.classList.toggle(\'dark-mode\');
    
    // Tema tercihini kaydet
    const isDarkMode = document.body.classList.contains(\'dark-mode\');
    localStorage.setItem(\'mobileTheme\', isDarkMode ? \'dark\' : \'light\');
}

function initMobileTheme() {
    const savedTheme = localStorage.getItem(\'mobileTheme\');
    if (savedTheme === \'dark\') {
        document.body.classList.add(\'dark-mode\');
    }
}

// Hızlı eylemler
function quickAction(action) {
    switch(action) {
        case \'refresh\':
            refreshMobileData();
            break;
        case \'settings\':
            window.location.href = \'settings.php\';
            bottom
        case \'profile\':
            window.location.href = \'profile.php\';
            break;
        case \'logout\':
            window.location.href = \'logout.php\';
            break;
        case \'scan\':
            // QR kod tarama
            window.location.href = \'flasher.php\';
            break;
    }
}

// Sayfa yüklendiğinde başlat
document.addEventListener(\'DOMContentLoaded\', function() {
    initMobileTheme();
    refreshMobileData();
    
    // Her 30 saniyede bir verileri yenile
    setInterval(refreshMobileData, 30000);
});

// Ekran boyutu değiştiğinde kontrol et
window.addEventListener(\'resize\', function() {
    // Mobil uyumluluğu kontrol et
    if (window.innerWidth <= 768) {
        // Mobil görünüm
        document.body.classList.add(\'mobile-view\');
    } else {
        // Masaüstü görünüm
        document.body.classList.remove(\'mobile-view\');
    }
});
</script>';

require_once 'layouts/header.php';
?>

<div class="mobile-container">
    <!-- Mobil Header -->
    <div class="mobile-header">
        <div class="d-flex justify-content-between align-items-center">
            <h4 class="mb-0">DMAppsESP</h4>
            <button class="btn btn-sm btn-light" onclick="toggleMobileMenu()">☰</button>
        </div>
    </div>
    
    <!-- Mobil Navigasyon -->
    <div class="mobile-nav" id="mobileNav" style="display: none;">
        <div class="nav-item" data-section="dashboard" onclick="showMobileSection(\'dashboard\')">
            <span class="nav-icon">🏠</span>
            <span>Dashboard</span>
        </div>
        <div class="nav-item" data-section="devices" onclick="showMobileSection(\'devices\')">
            <span class="nav-icon">📱</span>
            <span>Cihazlar</span>
        </div>
        <div class="nav-item" data-section="sensors" onclick="showMobileSection(\'sensors\')">
            <span class="nav-icon">📊</span>
            <span>Sensörler</span>
        </div>
        <div class="nav-item" data-section="alerts" onclick="showMobileSection(\'alerts\')">
            <span class="nav-icon">🔔</span>
            <span>Uyarılar</span>
        </div>
        <div class="nav-item" data-section="settings" onclick="quickAction(\'settings\')">
            <span class="nav-icon">⚙️</span>
            <span>Ayarlar</span>
        </div>
    </div>
    
    <!-- Dashboard Bölümü -->
    <div class="mobile-section" id="dashboard">
        <div class="mobile-card">
            <h5>Genel Durum</h5>
            <div class="mobile-stats">
                <div class="mobile-stat">
                    <div class="value" id="totalDevices">0</div>
                    <div class="label">Cihaz</div>
                </div>
                <div class="mobile-stat">
                    <div class="value" id="onlineDevices">0</div>
                    <div class="label">Aktif</div>
                </div>
                <div class="mobile-stat">
                    <div class="value" id="totalSensors">0</div>
                    <div class="label">Sensör</div>
                </div>
                <div class="mobile-stat">
                    <div class="value" id="dataPoints">0</div>
                    <div class="label">Veri</div>
                </div>
            </div>
            <button class="mobile-button" onclick="refreshMobileData()">Yenile</button>
        </div>
        
        <div class="mobile-card">
            <h5>Hızlı Eylemler</h5>
            <button class="mobile-button" onclick="quickAction(\'scan\')">📷 QR Tara</button>
            <button class="mobile-button secondary" onclick="quickAction(\'refresh\')">🔄 Yenile</button>
            <button class="mobile-button success" onclick="quickAction(\'profile\')">👤 Profil</button>
            <button class="mobile-button danger" onclick="quickAction(\'logout\')">🚪 Çıkış</button>
        </div>
    </div>
    
    <!-- Cihazlar Bölümü -->
    <div class="mobile-section" id="devices" style="display: none;">
        <div class="mobile-card">
            <h5>Cihazlarım</h5>
            <div class="mobile-device-list" id="mobileDeviceList">
                <p class="text-muted">Cihazlar yükleniyor...</p>
            </div>
            <button class="mobile-button" onclick="window.location.href=\'add_device.php\'">+ Cihaz Ekle</button>
        </div>
    </div>
    
    <!-- Sensörler Bölümü -->
    <div class="mobile-section" id="sensors" style="display: none;">
        <div class="mobile-card">
            <h5>Sensör Verileri</h5>
            <div class="mobile-sensor-grid" id="mobileSensorGrid">
                <p class="text-muted">Sensör verileri yükleniyor...</p>
            </div>
        </div>
    </div>
    
    <!-- Uyarılar Bölümü -->
    <div class="mobile-section" id="alerts" style="display: none;">
        <div class="mobile-card">
            <h5>Sistem Uyarıları</h5>
            <div id="mobileAlerts">
                <p class="text-muted">Uyarılar yükleniyor...</p>
            </div>
        </div>
    </div>
    
    <!-- Alt Navigasyon -->
    <div class="mobile-bottom-nav">
        <div class="nav-item" onclick="showMobileSection(\'dashboard\')">
            <div class="nav-icon">🏠</div>
            <div class="nav-label">Ana Sayfa</div>
        </div>
        <div class="nav-item" onclick="showMobileSection(\'devices\')">
            <div class="nav-icon">📱</div>
            <div class="nav-label">Cihazlar</div>
        </div>
        <div class="nav-item" onclick="showMobileSection(\'sensors\')">
            <div class="nav-icon">📊</div>
            <div class="nav-label">Sensörler</div>
        </div>
        <div class="nav-item" onclick="showMobileSection(\'alerts\')">
            <div class="nav-icon">🔔</div>
            <div class="nav-label">Uyarılar</div>
        </div>
    </div>
</div>

<?php require_once 'layouts/footer.php'; ?>
