<?php
require_once 'config/database.php';

// Debug session
error_log("Session data: " . print_r($_SESSION, true));

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    error_log("No user_id in session, redirecting to login");
    header('Location: login.php');
    exit();
}

// Get user info
$user_id = $_SESSION['user_id'];
error_log("Looking for user with ID: " . $user_id);
$sql = "SELECT username, email, role, first_name, last_name, created_at, last_login FROM users WHERE id = $user_id";
error_log("SQL Query: " . $sql);
$result = $con->query($sql);
$user = $result ? $result->fetch_assoc() : null;

// If user not found, create empty user array to prevent sidebar errors
if (!$user) {
    $user = [
        'username' => 'Unknown',
        'email' => '',
        'role' => 'user',
        'first_name' => '',
        'last_name' => '',
        'created_at' => '',
        'last_login' => ''
    ];
    error_log("User not found, using empty array");
}



// Layout variables
$page_title = 'Profil';
$breadcrumb_title = 'Profil';
$current_page = 'profile';
$extra_css = '';
$page_scripts = '';
?>

<?php require_once 'layouts/header.php'; ?>

<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <?php require_once 'layouts/navbar.php'; ?>
    <?php require_once 'layouts/sidebar.php'; ?>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <?php require_once 'layouts/header_dashboard.php'; ?>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body text-center">
                            <img src="assets/img/user2-160x160.jpg" class="img-circle elevation-2" alt="User Image" style="width: 128px; height: 128px;">
                            <h4 class="mt-3"><?php echo htmlspecialchars($user['username']); ?></h4>
                            <p class="text-muted">
                                <span class="badge badge-<?php echo $user['role'] === 'admin' ? 'danger' : 'info'; ?>">
                                    <?php echo ucfirst($user['role']); ?>
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-user mr-1"></i>
                                Profil Bilgileri
                            </h3>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 150px;">Kullanıcı Adı</th>
                                    <td><?php echo htmlspecialchars($user['username']); ?></td>
                                </tr>
                                <tr>
                                    <th>Ad Soyad</th>
                                    <td><?php echo htmlspecialchars($user['full_name'] ?? '-'); ?></td>
                                </tr>
                                <tr>
                                    <th>E-posta</th>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                </tr>
                                <tr>
                                    <th>Rol</th>
                                    <td>
                                        <span class="badge badge-<?php echo $user['role'] === 'admin' ? 'danger' : 'info'; ?>">
                                            <?php echo ucfirst($user['role']); ?>
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Kayıt Tarihi</th>
                                    <td><?php echo date('d.m.Y H:i', strtotime($user['created_at'])); ?></td>
                                </tr>
                                <tr>
                                    <th>Son Giriş</th>
                                    <td><?php echo $user['last_login'] ? date('d.m.Y H:i', strtotime($user['last_login'])) : '-'; ?></td>
                                </tr>
                            </table>
                            
                            <div class="mt-3">
                                <a href="settings.php" class="btn btn-primary">
                                    <i class="fas fa-cog"></i> Ayarları Düzenle
                                </a>
                                <a href="dashboard.php" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left"></i> Geri Dön
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<?php require_once 'layouts/footer.php'; ?>
