<?php
session_start();
require_once 'config/database.php';

// Get user info
$user_id = $_SESSION['user_id'];
$sql = "SELECT username, email, role, first_name, last_name FROM users WHERE id = $user_id";
$result = $con->query($sql);
$user = $result ? $result->fetch_assoc() : null;

// If user not found, create empty user array to prevent sidebar errors
if (!$user) {
    $user = [
        'username' => 'Unknown',
        'email' => '',
        'role' => 'user',
        'first_name' => '',
        'last_name' => ''
    ];
}

// Layout variables
$page_title = 'Ayarlar';
$breadcrumb_title = 'Ayarlar';
$current_page = 'settings';
$extra_css = '';
$page_scripts = '';
?>

<?php require_once 'layouts/header.php'; ?>

<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <?php require_once 'layouts/navbar.php'; ?>
    <?php require_once 'layouts/sidebar.php'; ?>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <?php require_once 'layouts/header_dashboard.php'; ?>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-user-cog mr-1"></i>
                                Profil Ayarları
                            </h3>
                        </div>
                        <div class="card-body">
                            <form action="update_profile.php" method="POST">
                                <div class="form-group">
                                    <label for="username">Kullanıcı Adı</label>
                                    <input type="text" class="form-control" id="username" name="username" 
                                           value="<?php echo htmlspecialchars($user['username']); ?>" readonly>
                                </div>
                                
                                <div class="form-group">
                                    <label for="email">E-posta</label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="<?php echo htmlspecialchars($user['email']); ?>" readonly>
                                </div>
                                
                                <div class="form-group">
                                    <label for="full_name">Ad Soyad</label>
                                    <input type="text" class="form-control" id="full_name" name="full_name" 
                                           value="<?php echo htmlspecialchars($user['full_name'] ?? ''); ?>">
                                </div>
                                
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> Kaydet
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-lock mr-1"></i>
                                Şifre Değiştir
                            </h3>
                        </div>
                        <div class="card-body">
                            <form action="change_password.php" method="POST">
                                <div class="form-group">
                                    <label for="current_password">Mevcut Şifre</label>
                                    <input type="password" class="form-control" id="current_password" name="current_password" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="new_password">Yeni Şifre</label>
                                    <input type="password" class="form-control" id="new_password" name="new_password" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="confirm_password">Şifre Tekrar</label>
                                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                </div>
                                
                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-key"></i> Şifre Değiştir
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if ($user['role'] === 'admin'): ?>
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-cogs mr-1"></i>
                                Sistem Ayarları
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h5>Veritabanı Bilgileri</h5>
                                    <p><strong>Host:</strong> localhost</p>
                                    <p><strong>Database:</strong> dmapesp</p>
                                    <p><strong>Karakter Set:</strong> utf8mb4</p>
                                </div>
                                <div class="col-md-6">
                                    <h5>Sistem Bilgileri</h5>
                                    <p><strong>PHP Versiyonu:</strong> <?php echo phpversion(); ?></p>
                                    <p><strong>Server:</strong> XAMPP</p>
                                    <p><strong>Zaman Dilimi:</strong> <?php echo date_default_timezone_get(); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </section>
    </div>
</div>

<?php require_once 'layouts/footer.php'; ?>
